from typing import List

from pydantic import BaseModel

from model.Image import ImageBase
from model.LectureTopic import LectureTopicBase
from model.Topic import TopicBase
from model.VisualDocUnderstandingData import VisualDocUnderstandingDataBase


class LectureBase(BaseModel):
    text: str
    summary: str
    duration_seconds: int
    lecturer: str
    voice_language: str
    slides_language: str
    images: List[ImageBase]
    topics: List[LectureTopicBase]
    vdu_data: List[VisualDocUnderstandingDataBase]