
from fastapi import status
from typing import Any, Dict
from datetime import datetime




class ResponseModel:
    """
        @author: Jiri Martinek
        Global class for API responses. All responses will have a unified format
        Builder design pattern, use it instead of calling constructor with so many params
    """
    def __init__(self):
        self.response = {
            "timestamp": str(datetime.now()),
            "status_code": None,
            "http_status": None,
            "reason": None,
            "message": None,
            "developer_message": None,
            "data": {}
        }

    def __str__(self):
        return str(self.response)

    @staticmethod
    def builder():
        return ResponseModel()

    def add_status_code(self, status_code: int):
        self.response["status_code"] = status_code
        return self

    def add_http_status(self, http_status: str):
        self.response["http_status"] = http_status
        return self

    def add_message(self, message: str):
        self.response["message"] = message
        return self

    def add_developer_message(self, developer_message: str):
        self.response["developer_message"] = developer_message
        return self

    def add_data(self, dictionary):
        self.response["data"] = dictionary
        return self


if __name__ == '__main__':
    # testing builder
    response = ResponseModel.builder()
    print(response)
    data = {"a": [1, 2, 3]}
    response.add_data(data).add_message("Message")
    print(response)

