from abc import ABC, abstractmethod

from model.Lecture import LectureBase


class AbstractLectureRepository(ABC):

    @abstractmethod
    def create(self, lecture: LectureBase):
        pass

    @abstractmethod
    def get(self, lecture_id: int):
        pass

    @abstractmethod
    def get_list(self):
        pass

    @abstractmethod
    def delete(self, lecture_id: int):
        pass