from abc import ABC, abstractmethod

from model.Lecture import LectureBase


class AbstractLectureService(ABC):

    @abstractmethod
    def create(self, lecture: LectureBase):
        pass

    @abstractmethod
    def get(self, id: int):
        pass

    @abstractmethod
    def get_list(self, limit: int): ## for listing, e.g. only ten
        pass

    @abstractmethod
    def delete(self, id: int):
        pass
