from sqlalchemy.orm import Session
from model.Lecture import LectureBase
from repo.LectureRepository import LectureRepository
from service.AbstractLectureService import AbstractLectureService



class LectureService(AbstractLectureService):

    def __init__(self, db: Session):
        self.db = db
        self.lecture_repository = LectureRepository(db)

    def create(self, lecture: LectureBase):
        return self.lecture_repository.create(lecture)

    def get(self, id: int):
        return self.lecture_repository.get(id)

    def get_list(self, limit: int = 10, offset: int = 0):
        return self.lecture_repository.get_list(limit, offset)

    def delete(self, id: int):
        return self.lecture_repository.delete(id)