import numpy as np
from service.AbstractAudioService import AbstractAudioService
from config import paths
import os
from moviepy.editor import VideoFileClip
from pyAudioAnalysis import audioSegmentation
class MyAudioService(AbstractAudioService):

    def __init__(self, video_path):
        duration: int = 60 ## just first one minute of a lecture --> it should be enough to determine language and gender
        # Load the video
        video = VideoFileClip(video_path)
        # Extract the first `duration` seconds of audio
        audio = video.audio.subclip(0, duration)
        # Save the audio to file
        self.audio_filepath = os.path.join(paths.AUDIO_OUTPUT_FOLDER, "tmp_audio.wav")
        audio.write_audiofile(self.audio_filepath, codec="pcm_s16le")
        # print(f"Audio extracted and saved to {self.audio_filepath}")

    def determine_gender(self) -> str:
        # Gender classification using a pre-trained model
        model_name = os.path.join(paths.bin, "speech_recognition", "svm_rbf_speaker_male_female")

        labels, class_names, accuracy, cm = audioSegmentation.mid_term_file_classification(self.audio_filepath,
                                                                  model_name,
                                                                  "svm_rbf")

        male_scores = np.count_nonzero(labels)
        female_scores = len(labels) - np.count_nonzero(labels)
        # If flag is 0 --> female, if flag is 1 --> male
        if male_scores >= female_scores:
            gender = "m"
        else:
            gender = "f"
        print(f"Detected gender: {gender}")
        return gender


    def determine_spoken_language(self) -> str:
        # not implemented, TODO
        language = "UNK"
        return language