import numpy as np
from sentence_transformers import SentenceTransformer

from service.AbstractTextRepresentationService import AbstractTextRepresentationService


class SimpleTextRepresentationService(AbstractTextRepresentationService):

    def __init__(self, modelid):

        self.embedding_model = SentenceTransformer(modelid)

    def create_vector_representation(self, text: str) -> np.ndarray:
        embedding = self.embedding_model.encode(text, convert_to_numpy=True)
        return embedding