from transformers import pipeline

from service.AbstractTextSummarizationService import AbstractTextSummarizationService


class SimpleTextSummarizationService(AbstractTextSummarizationService):

    def __init__(self, modelid):
        self.modelid = modelid
        self.summarizer = pipeline("summarization", model=modelid)

    def make_summary(self, text: str) -> str:
        # Perform summarization
        summary = self.summarizer(text, max_length=100, min_length=30, do_sample=False)
        # do_sample=True --> bigger variability, otherwise it is deterministic
        # Output the summary
        # print("Summary:", summary[0]['summary_text'])
        return summary[0]['summary_text']

# if __name__ == '__main__':
#     text = """
#     Artificial Intelligence (AI) is a branch of computer science that aims to create machines
#     that can perform tasks that typically require human intelligence. These tasks include
#     problem-solving, recognizing patterns, understanding natural language, and even perception
#     and decision-making. AI systems are powered by algorithms that use data to learn and make
#     predictions or decisions. One of the key breakthroughs in AI has been machine learning,
#     which enables computers to learn from and make decisions based on data. AI is now used
#     in a wide range of applications, from self-driving cars and medical diagnostics to customer
#     service chatbots and recommendation engines.
#     """
#     model = SimpleTextSummarizationService("facebook/bart-large-cnn")
#     summary = model.make_summary(text=text)
#     print(summary)