import streamlit as st
import requests
import os

BACKEND_URL = os.getenv("BACKEND_URL", "http://localhost:8000")

st.set_page_config(page_title="Lecture Analyzer", page_icon="📺")

st.title("📹 📷 📺 Lecture Analyzer")

st.write("Go to the **Lectures** page from the sidebar to see already processed lectures.")

# Upload widget
uploaded_file = st.file_uploader("Choose a video file", type=["mp4", "avi", "mov", "mkv", "wav"])

if uploaded_file is not None:
    st.write(f"Selected file: **{uploaded_file.name}**")

    if st.button("Process file (upload to backend)"):
        with st.spinner("Performing video analysis. It may take a while..."):
            # must be "video" to match backend function argument
            files = {"video": (uploaded_file.name, uploaded_file, uploaded_file.type)}
            try:
                response = requests.post(f"{BACKEND_URL}/api/lecture/upload", files=files)
                if response.status_code == 200:
                    st.success("File uploaded successfully ✅")
                    st.subheader("Backend response:")
                    st.json(response.json())  # pretty JSON
                else:
                    st.error(f"Error {response.status_code}: {response.text}")
            except Exception as e:
                st.error(f"Failed to connect to backend: {e}")